import React from 'react';
import { useQuery, useAction } from 'wasp/client/operations';
import { Link } from 'wasp/client/router';

const HomePage = () => {
  const { data: services, isLoading, error } = useQuery(getServices);
  const createServiceFn = useAction(createService);

  if (isLoading) return 'Loading...';
  if (error) return 'Error: ' + error;

  return (
    <div className='p-4'>
      <h1 className='text-3xl font-bold mb-4'>Welcome to SMART VILLAGE SERVICES</h1>
      <p className='mb-4'>We provide comprehensive IT network services and maintenance, tailored to meet the diverse needs of businesses.</p>

      <h2 className='text-2xl font-bold mt-6 mb-4'>Service Categories:</h2>
      {services.map(service => (
        <div key={service.id} className='mb-6'>
          <h3 className='text-xl font-semibold mb-2'>{service.title}</h3>
          <p><strong>Target Clients:</strong> {service.category}</p>
          <p><strong>Packages:</strong> {service.packages}</p>
          <p><strong>Benefits:</strong> {service.benefits}</p>
          <Link to={`/service/${service.id}`} className='bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded'>Details</Link>
        </div>
      ))}

      <h2 className='text-2xl font-bold mt-6 mb-4'>Client Benefits:</h2>
      <div className='grid grid-cols-1 md:grid-cols-2 gap-4'>
        <div>
          <h3 className='text-xl font-semibold mb-2'>Gains:</h3>
          <ul className='list-disc pl-6'>
            <li>Improved network reliability and speed</li>
            <li>Enhanced security and data protection</li>
            <li>Proactive issue resolution and reduced downtime</li>
            <li>Access to specialized IT skills and expertise</li>
            <li>Increased productivity and operational efficiency</li>
          </ul>
        </div>
        <div>
          <h3 className='text-xl font-semibold mb-2'>Preventive Measures:</h3>
          <ul className='list-disc pl-6'>
            <li>Regular system health checks and maintenance</li>
            <li>Continuous monitoring to identify and resolve potential issues early</li>
            <li>Regular backups and disaster recovery planning</li>
            <li>Security audits and compliance management to mitigate risks</li>
          </ul>
        </div>
      </div>

      <h2 className='text-2xl font-bold mt-6 mb-4'>Pricing Structure:</h2>
      <p><strong>AMC:</strong> Annual payment</p>
      <p><strong>SLA:</strong> 2 months in advance, then monthly upon at least 6 months agreement or annual payment</p>
      <p><strong>MSH:</strong> 3 months in advance, then monthly upon annual agreement</p>

      <h2 className='text-2xl font-bold mt-6 mb-4'>Contact Us:</h2>
      <p>Feel free to contact us for a personalized consultation to determine the best package for your business needs.</p>
    </div>
  );
}

export default HomePage;