import React, { useState } from 'react';
import { useAction, createService } from 'wasp/client/operations';
import { Link } from 'wasp/client/router';

const CreateServicePage = () => {
  const createServiceFn = useAction(createService);
  const [formData, setFormData] = useState({
    title: '',
    description: '',
    category: '',
    packages: '',
    benefits: '',
    pricing: ''
  });

  const handleCreateService = () => {
    createServiceFn(formData);
    // Optionally add success message or redirect
  };

  return (
    <div className='p-4'>
      <input
        type='text'
        placeholder='Service Title'
        className='border p-2 mb-4 rounded'
        value={formData.title}
        onChange={(e) => setFormData({ ...formData, title: e.target.value })}
      />
      <textarea
        placeholder='Service Description'
        className='border p-2 mb-4 rounded'
        value={formData.description}
        onChange={(e) => setFormData({ ...formData, description: e.target.value })}
      ></textarea>
      <input
        type='text'
        placeholder='Service Category'
        className='border p-2 mb-4 rounded'
        value={formData.category}
        onChange={(e) => setFormData({ ...formData, category: e.target.value })}
      />
      <input
        type='text'
        placeholder='Service Packages'
        className='border p-2 mb-4 rounded'
        value={formData.packages}
        onChange={(e) => setFormData({ ...formData, packages: e.target.value })}
      />
      <input
        type='text'
        placeholder='Service Benefits'
        className='border p-2 mb-4 rounded'
        value={formData.benefits}
        onChange={(e) => setFormData({ ...formData, benefits: e.target.value })}
      />
      <input
        type='text'
        placeholder='Service Pricing'
        className='border p-2 mb-4 rounded'
        value={formData.pricing}
        onChange={(e) => setFormData({ ...formData, pricing: e.target.value })}
      />
      <button
        onClick={handleCreateService}
        className='bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded'
      >
        Create Service
      </button>
    </div>
  );
}

export default CreateServicePage;