import { HttpError } from 'wasp/server'

export const createService = async (args, context) => {
  if (!context.user) { throw new HttpError(401) };

  return context.entities.Service.create({
    data: {
      title: args.title,
      description: args.description,
      category: args.category,
      packages: args.packages,
      benefits: args.benefits,
      pricing: args.pricing,
      userId: context.user.id
    }
  });
}

export const updateService = async (args, context) => {
  if (!context.user) { throw new HttpError(401) };

  const service = await context.entities.Service.findUnique({
    where: { id: args.id },
    include: { Service: true }
  });

  if (service.userId !== context.user.id) { throw new HttpError(403) };

  return context.entities.Service.update({
    where: { id: args.id },
    data: {
      title: args.title,
      description: args.description,
      category: args.category,
      packages: args.packages,
      benefits: args.benefits,
      pricing: args.pricing
    }
  });
}