import React from 'react';
import { useParams } from 'react-router-dom';
import { useQuery, getService } from 'wasp/client/operations';
import { Link } from 'wasp/client/router';

const ServicePage = () => {
  const { id } = useParams();
  const { data: service, isLoading, error } = useQuery(getService, { id: parseInt(id) });

  if (isLoading) return 'Loading...';
  if (error) return 'Error: ' + error;

  return (
    <div className='p-4'>
      <h1 className='text-3xl font-bold'>{service.title}</h1>
      <p className='text-lg mt-2'>{service.description}</p>
      <p className='mt-4'>Category: {service.category}</p>
      <p>Packages: {service.packages}</p>
      <p>Benefits: {service.benefits}</p>
      <p>Pricing: {service.pricing}</p>
      <Link to='/contact' className='block mt-4 text-blue-500 hover:underline'>Contact Us for a Personalized Consultation</Link>
    </div>
  );
}

export default ServicePage;