import React, { useState, useEffect } from 'react';
import { useParams } from 'react-router-dom';
import { useQuery, useAction, getService, updateService } from 'wasp/client/operations';
import { Link } from 'wasp/client/router';

const EditService = () => {
  const { id } = useParams();
  const [service, setService] = useState(null);
  const [updatedService, setUpdatedService] = useState(null);
  const getServiceFn = useQuery(getService);
  const updateServiceFn = useAction(updateService);

  useEffect(() => {
    const fetchService = async () => {
      const fetchedService = await getServiceFn({ id: parseInt(id) });
      setService(fetchedService);
      setUpdatedService(fetchedService);
    };
    fetchService();
  }, [id, getServiceFn]);

  const handleUpdateService = () => {
    updateServiceFn(updatedService);
  };

  if (!service) return 'Loading...';

  return (
    <div className='p-4'>
      <h1 className='text-2xl font-bold mb-4'>Edit Service</h1>
      <input type='text' value={updatedService.title} onChange={(e) => setUpdatedService({ ...updatedService, title: e.target.value })} className='border rounded py-2 px-3 mb-2' />
      <textarea value={updatedService.description} onChange={(e) => setUpdatedService({ ...updatedService, description: e.target.value })} className='border rounded py-2 px-3 mb-2'></textarea>
      <input type='text' value={updatedService.category} onChange={(e) => setUpdatedService({ ...updatedService, category: e.target.value })} className='border rounded py-2 px-3 mb-2' />
      <button onClick={handleUpdateService} className='bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded'>Update Service</button>
    </div>
  );
}

export default EditService;